--
--
------------------------------------------------------------------------------------------------------- 
-- Miguel Fichier Revision M33.d
------------------------------------------------------------------------------------------------------- 
-- Miguel21 modification M33.d VOR + NDB Custom Briefing (d: Divert)

--[[ db_airbases Entry Example ----------------------------------------------------------------------------
	--example for an air base
	['Kerman Airbase'] = {
		x =	454116.78125,
		y = 71096.058594,
		elevation = 1751,
		airdromeId = 18,
		ATC_frequency = "250.300",
		--startup = 300,							-- (secondes) Timing for take-off, generally used for small runways to give time for all aircraft to gather together
		side = "red",								-- side : Required information for the divert
		divert = true,								-- divert : Required information for the divert)
		--VOR = "112.00",							-- optional information
		--NDB = "",									-- optional information
		--TACAN = "97X",							-- TACAN : optional information
		--ILS = "RWY 30R/111.95 RWY 12L/108.55",	-- ILS : optional information
		LimitedParkNb = 3,							-- number of parking spaces available
	},
	--example for an airplane carrier
	['CVN-71 Theodore Roosevelt'] = {                            
		unitname = "CVN-71 Theodore Roosevelt",
		startup = 300,								-- (secondes) Timing for take-off, generally used for small runways to give time for all aircraft to gather together
		ATC_frequency = "255.500",					-- Optional information, if absent, the base_mission frequency will be used.
	},	
	--example for a FARP
	['As Salamah FARP'] = {
		x =	-74348.375716192,
		y = -67705.331836707,
		elevation = 0,
		airdromeId = 837,							--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 837,
		ATC_frequency = "128.600",
		side = "blue",								-- side : Required information for the divert
		divert = false,								-- divert : Required information for the divert)
	},	
	--example for a Virtual Base
	['Reserves'] = {								--dummy airbase to place virtual reserves
		inactive = true,
		x =	9999999999,								--position far away will make all range checks negative
		y = 9999999999,
		elevation = 0,
		airdromeId = nil,							--no id makes sure that no static aircraft are to be placed at this air base
		ATC_frequency = "0",
	},

]]-----------------------------------------------------------------------------------------------------

db_airbases = {
	['Sanliurfa Airbase'] = {
		x = 264719.125,
		y = 273812.4375,
		elevation = 824,
		airdromeId = 58,
		ATC_frequency = "252.350",
		---ATC_frequency = "118.400",
		-- ATC_frequency = "40.800",
		-- ATC_frequency = "4.950",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 11,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Incirlik Airbase'] = {
		x =	221207.765625,
		y = -35240.335938,
		elevation = 58,
		airdromeId = 16,
		ATC_frequency = "360.100",
		---ATC_frequency = "122.100",
		-- ATC_frequency = "38.700",
		-- ATC_frequency = "3.900",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		TACAN = "21X",							-- TACAN : optionnel
		ILS = "RWY 55/109.30 - RWY 235/111.70",							-- ILS : optionnel
		LimitedParkNb = 120,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Adana Sakirpasa Airbase'] = {
		x =	219468.65625,
		y = -48332.732422,
		elevation = 17,
		airdromeId = 2,
		-- ATC_frequency = "39.450",
		-- ATC_frequency = "121.100",
		ATC_frequency = "251.000",
		-- ATC_frequency = "4.275",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "112.70",
		NDB = "395",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 56/108.70",							-- ILS : optionnel
		LimitedParkNb = 39,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Gaziantep Airbase'] = {   
		x =	210314.796875,
		y = 147379.28125,
		elevation = 681,
		airdromeId = 11,
		-- ATC_frequency = "38.450",
		-- ATC_frequency = "120.100",
		ATC_frequency = "250.050",
		-- ATC_frequency = "3.775",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "116.70",
		NDB = "432",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 286/109.10",							-- ILS : optionnel
		LimitedParkNb = 12,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},	
	['Gazipasa Airbase'] = {
		x =	158144.617188,
		y = -319392.546875,
		elevation = 24,
		airdromeId = 41,
		-- ATC_frequency = "40.100",
		-- ATC_frequency = "119.250",
		ATC_frequency = "251.650",
		-- ATC_frequency = "4.600",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "114.2",
		NDB = "316",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 86/108.50",							-- ILS : optionnel
		LimitedParkNb = 6,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Kharab Ishk Airbase'] = {     -- Helicopter base
		x = 164825.84375,
		y = 245883.84375,
		elevation = 431,
		airdromeId = 59,
		ATC_frequency = "252.400",
		---ATC_frequency = "122.200",
		-- ATC_frequency = "40.850",
		-- ATC_frequency = "4.975",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 11,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Tal Siman Airbase'] = {     -- Helicopter base
		x = 133191.875,
		y = 276361.453125,
		elevation = 299,
		airdromeId = 60,
		ATC_frequency = "252.500",
		---ATC_frequency = "121.900",
		-- ATC_frequency = "40.950",
		-- ATC_frequency = "5.025",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 04,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Minakh Airbase'] = {
		x =	163697.53125,
		y = 107430.609375,
		elevation = 492,
		airdromeId = 26,
		-- ATC_frequency = "39.250",
		-- ATC_frequency = "120.600",
		ATC_frequency = "250.800",
		-- ATC_frequency = "4.175",
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 20,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Hatay Airbase'] = {
		x =	147687.484375,
		y = 39418.742188,
		elevation = 77,
		airdromeId = 15,
		-- ATC_frequency = "38.650",
		-- ATC_frequency = "128.500",
		ATC_frequency = "250.250",
		-- ATC_frequency = "3.875",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "112.05",
		NDB = "336",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 44/108.90 - RWY 224/108.15",		-- ILS : optionnel
		LimitedParkNb = 10,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},	
	['Aleppo Airbase'] = {
		x =	125576.863281,
		y = 123125.304688,
		elevation = 382,
		airdromeId = 27,
		-- ATC_frequency = "39.300",
		-- ATC_frequency = "119.100",
		ATC_frequency = "250.850",
		-- ATC_frequency = "4.200",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "114.50",
		NDB = "396",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 8,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Kuweires Airbase'] = {   
		x =	125810.890625,
		y = 155253.8125,
		elevation = 366,
		airdromeId = 31,
		-- ATC_frequency = "39.550",
		-- ATC_frequency = "120.500",
		ATC_frequency = "251.100",
		-- ATC_frequency = "4.325",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 37,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Jirah Airbase'] = {  
		x =	115359.652344,
		y = 187020.734375,
		elevation = 353,
		airdromeId = 17,
		-- ATC_frequency = "38.750",
		-- ATC_frequency = "118.100",
		ATC_frequency = "250.300",
		-- ATC_frequency = "3.925",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 28,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Taftanaz Airbase'] = {
		x =	103485.980469,
		y = 82766.671875,
		elevation = 311,
		airdromeId = 38,
		-- ATC_frequency = "39.900",
		-- ATC_frequency = "122.800",
		ATC_frequency = "251.450",
		-- ATC_frequency = "4.500",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 48,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Tabqa Airbase'] = {
		x =	76964.6875,
		y = 243605.210938,
		elevation = 335,
		airdromeId = 37,
		-- ATC_frequency = "39.850",
		-- ATC_frequency = "118.500",
		ATC_frequency = "251.400",
		-- ATC_frequency = "4.475",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 27,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},	
	['Abu al-Duhur Airbase'] = {
		x =	76048.957031,
		y = 111344.925781,
		elevation = 250,
		airdromeId = 1,
		--  ATC_frequency = "38.900",
		-- ATC_frequency = "122.200",
		ATC_frequency = "250.450",
		-- ATC_frequency = "4.000",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 36,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Bassel Al-Assad Airbase'] = {
		x =	41994.498047,
		y = 5841.909424,
		elevation = 29,
		airdromeId = 21,
		-- ATC_frequency = "39.000",
		-- ATC_frequency = "118.100",
		ATC_frequency = "250.550",
		-- ATC_frequency = "4.050",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "114.80",
		NDB = "414",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 179/109.10",							-- ILS : optionnel
		LimitedParkNb = 53,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Deir ez-Zor Airbase'] = {     
		x = 25648.478515625,
		y = 390531,
		elevation = 209,
		airdromeId = 42,
		ATC_frequency = "251.700",
		---ATC_frequency = "118.100",
		-- ATC_frequency = "40.150",
		-- ATC_frequency = "4.625",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "117.00",
		NDB = "295",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 05,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Hama Airbase'] = {
		x =	8662.594238,
		y = 74333.1875,
		elevation = 300,
		airdromeId = 14,
		-- ATC_frequency = "38.600",
		-- ATC_frequency = "118.050",
		ATC_frequency = "250.200",
		-- ATC_frequency = "3.850",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 46,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Rene Mouawad Airbase'] = {
		x =	-48306.007813,
		y = 8690.693604,
		elevation = 5,
		airdromeId = 33,
		-- ATC_frequency = "39.650",
		-- ATC_frequency = "121.000",
		ATC_frequency = "251.200",
		-- ATC_frequency = "4.375",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		NDB = "450",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 13,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Al Qusayr Airbase'] = {  
		x =	-51906.964844,
		y = 60013.205078,
		elevation = 527,
		airdromeId = 3,
		-- ATC_frequency = "40.000",
		-- ATC_frequency = "119.200",
		ATC_frequency = "251.550",
		-- ATC_frequency = "4.550",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 34,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Palmyra Airbase'] = {  
		x =	-55704.023438,
		y = 220114.742188,
		elevation = 394,
		airdromeId = 28,
		-- ATC_frequency = "39.350",
		-- ATC_frequency = "121.900",
		ATC_frequency = "250.900",
		-- ATC_frequency = "4.225",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		NDB = "337",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 22,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Tiyas Airbase'] = {
		x =	-58907.53125,
		y = 157071.484375,
		elevation = 548,
		airdromeId = 39,
		-- ATC_frequency = "39.950",
		-- ATC_frequency = "120.500",
		ATC_frequency = "251.500",
		-- ATC_frequency = "4.525",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 81,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Shayrat Airbase'] = {
		x =	-61368.207031,
		y = 90675.136719,
		elevation = 804,
		airdromeId = 36,
		-- ATC_frequency = "39.800",
		-- ATC_frequency = "120.200",
		ATC_frequency = "251.350",
		-- ATC_frequency = "4.450",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 56,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Wujah Al Hajar Airbase'] = {
		x =	-81524.375,
		y = -22832.533203,
		elevation = 198,
		airdromeId = 40,
		-- ATC_frequency = "40.050",
		-- ATC_frequency = "121.500",
		ATC_frequency = "251.600",
		-- ATC_frequency = "4.575",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "116.20",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 6,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['An Nasiriyah Airbase'] = {
		x =	-124683.738281,
		y = 85510.820313,
		elevation = 832, 
		airdromeId = 4,
		-- ATC_frequency = "40.500",
		-- ATC_frequency = "122.300",
		ATC_frequency = "252.050",
		-- ATC_frequency = "4.800",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 20,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Rayak Airbase'] = {
		x =	-130132.492188,
		y = 4053.336304,
		elevation = 909, 
		airdromeId = 32,
		-- ATC_frequency = "39.600",
		-- ATC_frequency = "124.400",
		ATC_frequency = "251.150",
		-- ATC_frequency = "4.350",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 12,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Beirut-Rafic Hariri Airbase'] = {
		x =	-131310.8125,
		y = -42286.496094,
		elevation = 12,
		airdromeId = 6,
		-- ATC_frequency = "41.050",
		-- ATC_frequency = "118.900",
		ATC_frequency = "252.600",
		-- ATC_frequency = "5.075",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "112.60",
		NDB = "351",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 169/110.10 - RWY 179/109.50 - RWY 35/110.70",		-- ILS : optionnel
		LimitedParkNb = 34,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Sayqal Airbase'] = {
		x =	-151781.367188,
		y = 117529.734375,
		elevation = 693,
		airdromeId = 35,
		-- ATC_frequency = "39.750",
		-- ATC_frequency = "120.400",
		ATC_frequency = "251.300",
		-- ATC_frequency = "4.425",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 59,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Al-Dumayr Airbase'] = {
		x =	-158713.039063,
		y = 73973.316406,
		elevation = 630,
		airdromeId = 9,
		-- ATC_frequency = "41.200",
		-- ATC_frequency = "120.300",
		ATC_frequency = "252.750",
		-- ATC_frequency = "5.150",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 57,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['At Tanf Airbase'] = {     -- Helicopter base
		x = -172339.65625,
		y = 247058.453125,
		elevation = 209,
		airdromeId = 63,
		ATC_frequency = "252.550",
		---ATC_frequency = "121.100",
		-- ATC_frequency = "41.000",
		-- ATC_frequency = "5.050",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 02,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Marj as Sultan North Airbase'] = {		-- Helicopter base
		x =	-170244.028992,
		y = 47506.718825,
		elevation = 612,
		airdromeId = 22,
		-- ATC_frequency = "39.050",
		-- ATC_frequency = "122.700",
		ATC_frequency = "250.600",
		-- ATC_frequency = "4.075",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",			-- ILS : optionnel
		LimitedParkNb = 14,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Marj as Sultan South Airbase'] = {		-- Helicopter base
		x =	-171711.336701,
		y = 48243.74032,
		elevation = 612,
		airdromeId = 8,
		-- ATC_frequency = "41.150",
		-- ATC_frequency = "122.900",
		ATC_frequency = "252.700",
		-- ATC_frequency = "5.125",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",			-- ILS : optionnel
		LimitedParkNb = 20,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Mezzeh Airbase'] = {   
		x =	-172160.453125,
		y = 24865.682617,
		elevation = 720,
		airdromeId = 25,
		-- ATC_frequency = "39.200",
		-- ATC_frequency = "120.700",
		ATC_frequency = "250.750",
		-- ATC_frequency = "4.150",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 28,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Qabr as Sitt Airbase'] = {
		-- Helicopter base
		x =	 -174597.761535,
		y =  37221.970678,
		elevation = 651,
		airdromeId = 29,
		-- ATC_frequency = "39.400",
		-- ATC_frequency = "122.600",
		ATC_frequency = "250.950",
		-- ATC_frequency = "4.250",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 8,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Damascus Airbase'] = {
		x =	 -178652.320313,
		y =  52081.296875,
		elevation = 612,
		airdromeId = 7,
		-- ATC_frequency = "41.400",
		-- ATC_frequency = "118.500",
		ATC_frequency = "252.650",
		-- ATC_frequency = "5.100",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "116.00",
		NDB = "342",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 230/109.90 - 50/111.10",							-- ILS : optionnel
		LimitedParkNb = 90,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Marj Ruhayyil Airbase'] = {             
		x =	 -194233.6875,
		y =  46043.976563,
		elevation = 659,
		airdromeId = 23,
		-- ATC_frequency = "39.100",
		-- ATC_frequency = "120.800",
		ATC_frequency = "250.650",
		-- ATC_frequency = "4.100",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 33,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Kiryat Shmona Airbase'] = {             
		x =	 -199486.164063,
		y =  -34500.691406,
		elevation = 101,
		airdromeId = 20,
		-- ATC_frequency = "38.950",
		-- ATC_frequency = "118.400",
		ATC_frequency = "250.500",
		-- ATC_frequency = "4.025",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 5,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Naqoura Airbase'] = {             
		-- Helicopter base
		x =	 -209938.1875,
		y =  -78642.609375,
		elevation = 115,
		airdromeId = 52,
		-- ATC_frequency = "40.650",
		-- ATC_frequency = "122.000",
		ATC_frequency = "252.200",
		-- ATC_frequency = "4.875",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 9,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Khalkhalah Airbase'] = {             
		x =	 -218620.25,
		y =  56161.078125,
		elevation = 724,
		airdromeId = 18,
		-- ATC_frequency = "38.800",
		-- ATC_frequency = "122.500",
		ATC_frequency = "250.350",
		-- ATC_frequency = "3.950",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 35,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['H3 Northwest Airbase'] = {             
		x =	 -220000.35156,
		y =  338483.561903,
		elevation = 785,
		airdromeId = 54,
		-- ATC_frequency = "38.800",
		-- ATC_frequency = "122.500",
		ATC_frequency = "",                  ---Pas de frequence radio
		-- ATC_frequency = "3.950",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 21,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['H3 Airbase'] = {             
		x =	 -235405.664063,
		y =  352522.65625,
		elevation = 777,
		airdromeId = 53,
		-- ATC_frequency = "40.700",
		-- ATC_frequency = "122.000",
		ATC_frequency = "252.250",                  
		-- ATC_frequency = "4.900",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 52,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['H3 Southwest Airbase'] = {             
		x =	 -256859.445313,
		y =  339219.1875,
		elevation = 814,
		airdromeId = 55,
		-- ATC_frequency = "40.700",
		-- ATC_frequency = "122.000",
		ATC_frequency = "",                    ---Pas de frequence radio
		-- ATC_frequency = "4.900",
		startup = 300,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 22,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Rosh Pina Airbase'] = {             
		x =	 -225277.733943,
		y =  -37687.536255,
		elevation = 265,
		airdromeId = 34,
		-- ATC_frequency = "39.700",
		-- ATC_frequency = "118.450",
		ATC_frequency = "251.250",
		-- ATC_frequency = "4.400",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "115.30",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 9,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Haifa Airbase'] = {             
		x =	 -242620.8125,
		y =  -87704.417969,
		elevation = 6,
		airdromeId = 13,
		-- ATC_frequency = "38.550",
		-- ATC_frequency = "127.800",
		ATC_frequency = "250.150",
		-- ATC_frequency = "3.825",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 11,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Tha lah Airbase'] = {             
		x =	 -258434.929688,
		y =  40368.677734,
		elevation = 733,
		airdromeId = 5,
		-- ATC_frequency = "40.900",
		-- ATC_frequency = "122.400",
		ATC_frequency = "252.450",
		-- ATC_frequency = "5.000",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 16,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Ramat David Airbase'] = {             
		x =	 -259102.132813,
		y =  -75789.410156,
		elevation = 36,
		airdromeId = 30,
		-- ATC_frequency = "39.500",
		-- ATC_frequency = "118.600",
		ATC_frequency = "251.050",
		-- ATC_frequency = "4.300",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		NDB = "368",
		TACAN = "84X - 113.70",							-- TACAN : optionnel
		ILS = "RWY 326/111.10",							-- ILS : optionnel
		LimitedParkNb = 42,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Meggido Airbase'] = {             
		x =	 -266965.015625,
		y =  -71068.832031,
		elevation = 55,
		airdromeId = 24,
		-- ATC_frequency = "39.150",
		-- ATC_frequency = "119.900",
		ATC_frequency = "250.700",
		-- ATC_frequency = "4.125",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 9,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['H4 Airbase'] = {             
		x =	 -279366.765625,
		y =  207219.265625,
		elevation = 688,
		airdromeId = 12,
		-- ATC_frequency = "38.500",
		-- ATC_frequency = "122.600",
		ATC_frequency = "250.100",
		-- ATC_frequency = "3.800",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 12,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Eyn Shemer Airbase'] = {             
		x =	 -283538.6875,
		y =  -92619.707031,
		elevation = 31,
		airdromeId = 10,
		-- ATC_frequency = "38.400",
		-- ATC_frequency = "123.400",
		ATC_frequency = "250.000",
		-- ATC_frequency = "3.750",
		startup = 600,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 5,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Ruwayshid Airbase'] = {             
		x =	 -295091.03125,
		y =  295237.5,
		elevation = 906,
		airdromeId = 57,
		-- ATC_frequency = "40.750",
		-- ATC_frequency = "122.100",
		ATC_frequency = "252.300",
		-- ATC_frequency = "4.925",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 16,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['King Hussein Air College Airbase'] = {             
		x =	 -296592.405413,
		y =  24944.355658,
		elevation = 672,
		airdromeId = 19,
		-- ATC_frequency = "38.850",
		-- ATC_frequency = "118.300",
		ATC_frequency = "250.400",
		-- ATC_frequency = "3.975",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 52,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Pinarbashi Airbase'] = {             
		x =	 38639.882813,
		y =  -238774.6875,
		elevation = 235,
		airdromeId = 51,
		-- ATC_frequency = "40.600",
		-- ATC_frequency = "121.000",
		ATC_frequency = "252.150",
		-- ATC_frequency = "4.850",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 4,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Gecitkale Airbase'] = {             
		x =	 32144.729634,
		y =  -197767.51907,
		elevation = 45,
		airdromeId = 50,
		-- ATC_frequency = "40.550",
		-- ATC_frequency = "120.000",
		ATC_frequency = "252.100",
		-- ATC_frequency = "4.825",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "114.30",
		NDB = "435",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 3,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Ercan Airbase'] = {             
		x =	 24250.327148,
		y =  -218240.28125,
		elevation = 117,
		airdromeId = 49,
		-- ATC_frequency = "40.450",
		-- ATC_frequency = "120.200",
		ATC_frequency = "252.000",
		-- ATC_frequency = "4.775",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "117.00",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 7,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Lakatamia Airbase'] = {             
		-- Helicopter base
		x =	 19561.164063,
		y =  -234985.75,
		elevation = 231,
		airdromeId = 48,
		-- ATC_frequency = "40.400",
		-- ATC_frequency = "120.200",
		ATC_frequency = "251.950",
		-- ATC_frequency = "4.750",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 8,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Kingsfield Airbase'] = {
		x =	 7596.761963,
		y =  -199426.492188,
		elevation = 86,
		airdromeId = 45,
		-- ATC_frequency = "40.250",
		-- ATC_frequency = "121.000",
		ATC_frequency = "251.800",
		-- ATC_frequency = "4.675",
		startup = 600,
		side = "red",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		-- NDB = "",
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 2,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Larnaca Airbase'] = {
		x =	 -7674.737061,
		y =  -208843.625,
		elevation = 5,
		airdromeId = 47,
		-- ATC_frequency = "40.350",
		-- ATC_frequency = "121.200",
		ATC_frequency = "251.900",
		-- ATC_frequency = "4.725",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		VOR = "112.80",
		NDB = "432",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 228/110.80",							-- ILS : optionnel
		LimitedParkNb = 94,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Paphos Airbase'] = {
		x =	 -18696.34668,
		y =  -314208.375,
		elevation = 12,
		airdromeId = 46,
		-- ATC_frequency = "40.300",
		-- ATC_frequency = "119.900",
		ATC_frequency = "251.850",
		-- ATC_frequency = "4.700",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		VOR = "117.90",
		NDB = "328",
		-- TACAN = "",							-- TACAN : optionnel
		ILS = "RWY 294/108.90",							-- ILS : optionnel
		LimitedParkNb = 49,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Akrotiri Airbase'] = {
		x =	 -35778.628906,
		y =  -268906.125,
		elevation = 20,
		airdromeId = 44,
		-- ATC_frequency = "40.200",
		-- ATC_frequency = "128.000",
		ATC_frequency = "251.750",
		-- ATC_frequency = "4.650",
		startup = 300,
		side = "blue",							-- side : info obligatoire
		divert = true,							-- divert : info obligatoire (pour l instant)
		-- VOR = "",
		NDB = "365",
		TACAN = "107X-116.00",							-- TACAN : optionnel
		ILS = "RWY 291/109.70",							-- ILS : optionnel
		LimitedParkNb = 41,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['FARP-London'] = {                            ----Crisis in PG campaigns only
		x =	-8686.627718003,
		y = -250921.24950583,
		elevation = 427,
		airdromeId = 101,	--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 101,
		ATC_frequency = "129.500",
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 4,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['FARP-Dallas'] = {                            ----Crisis in PG campaigns only
		x =	-8740.3980354112,
		y = -249731.64830353,
		elevation = 384,
		airdromeId = 199,	--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 199,
		ATC_frequency = "129.600",
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 4,
	},
	['FARP-Dublin'] = {                            ----Crisis in PG campaigns only
		x =	19643.800331041,
		y = -234054.34501055,
		elevation = 216,
		airdromeId = 232,	--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 232,
		ATC_frequency = "129.700",
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 4,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['FARP-Perth'] = {                            ----Crisis in PG campaigns only
		x = -8357.8030311526,
		y = -250908.28810597,
		elevation = 438,
		airdromeId = 237,	--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 237,
		ATC_frequency = "129.400",
		side = "blue",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 4,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['FARP-Madrid'] = {                            ----Crisis in PG campaigns only
		x =	20758.79834497,
		y = -198761.43526331,
		elevation = 34,
		airdromeId = 210,	--be careful this Id depends on units placements and is helipadID in fact
		helipadId = 199,
		ATC_frequency = "128.500",
		side = "red",							-- side : info obligatoire
		divert = false,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "",							-- TACAN : optionnel
		-- ILS = "",							-- ILS : optionnel
		LimitedParkNb = 4,
		LimitedMediumParkNb = "",
		LimitedSmallParkNb = "",
		LimitedLargeParkNb = "",
	},
	['Kasteli Airbase'] = {
		x = -00003194,
		y = -00575875, 
		elevation = 0,
		airdromeId = nil,
		ATC_frequency = "0",
		BaseAirStart = true,
		side = "blue",								-- side : Required information for the divert
		divert = false,								-- divert : Required information for the divert)
		--BaseAirStart = true,
	},
	-- ['CVN-74 John C. Stennis'] = {                            
		-- unitname = "CVN-74 John C. Stennis",
		-- startup = 300,
		-- LimitedParkNb  = 10,
		-- side = "blue",							-- side : info obligatoire
		-- ATC_frequency = "255.255",				--si ATC_frequency non present, on utilise la freq de base_mission
	-- },
	-- ['CVN-71 Theodore Roosevelt'] = {                            
		-- unitname = "CVN-71 Theodore Roosevelt",
		-- startup = 300,
		-- side = "blue",							-- side : info obligatoire
		-- -- ATC_frequency = "255.500",			--si ATC_frequency non present, on utilise la freq de base_mission
		-- LimitedParkNb  = 9, 
	-- },	
	-- ['LHA_Tarawa'] = {
		-- unitname = "LHA_Tarawa",
		-- startup = 300,
		-- side = "blue",							-- side : info obligatoire
		-- ATC_frequency = "250.255",				--si ATC_frequency non present, on utilise la freq de base_mission
		-- LimitedParkNb  = 4,
	-- },
	-- ['LHA_Nassau'] = {
		-- unitname = "LHA_Nassau",
		-- startup = 300,
		-- side = "blue",							-- side : info obligatoire
		-- ATC_frequency = "243.000",				--si ATC_frequency non present, on utilise la freq de base_mission	
		-- LimitedParkNb  = 4,
	-- },
	-- ['Al Ima FARP'] = {                            ----Crisis in PG campaigns only
		-- x =	-24720.872961233,
		-- y = 17485.114619878,
		-- elevation = 0,
		-- airdromeId = 1345,	--be careful this Id depends on units placements and is helipadID in fact
		-- helipadId = 1345,
		-- ATC_frequency = "128.500",
		-- side = "red",							-- side : info obligatoire
		-- divert = false,							-- divert : info obligatoire (pour l instant)
		-- -- TACAN = "",							-- TACAN : optionnel
		-- -- ILS = "",							-- ILS : optionnel
		-- LimitedParkNb = 4,
	-- },
	-- ['Jazirat al Hamra FARP'] = {        ----Crisis in PG campaigns only
		-- x =	-52316.710452899,
		-- y = -43324.847012614,
		-- elevation = 0,
		-- airdromeId = 837,	--be careful this Id depends on units placements and is helipadID in fact
		-- helipadId = 837,
		-- ATC_frequency = "243.000",
		-- side = "blue",							-- side : info obligatoire
		-- divert = false,							-- divert : info obligatoire (pour l instant)
		-- -- TACAN = "",							-- TACAN : optionnel
		-- -- ILS = "",							-- ILS : optionnel
		-- LimitedParkNb = 4,
	-- },
	-- ['FARP_Dublin'] = {
		-- x =	-31022.039393941,
		-- y = -122995.27024236,
		-- elevation = 12,
		-- airdromeId = 520,	--be careful this Id depends on units placements and is helipadID in fact
		-- ATC_frequency = "127.700",
	-- },
	-- ['FARP_Moscow'] = {
		-- x =	-27476.648084292,
		-- y = -170572.10615715,
		-- elevation = 6,
		-- airdromeId = 521,	--be careful this Id depends on units placements and is helipadID in fact
		-- ATC_frequency = "127.800",
	-- },	
	['Reserves'] = {						--dummy airbase to place virtual reserves
		inactive = true,
		x =	9999999999,						--position far away will make all range checks negative
		y = 9999999999,
		elevation = 0,
		airdromeId = nil,					--no id makes sure that no static aircraft are to be placed at this air base
		ATC_frequency = "251.0000",
	},
	-- ['AB test 01'] = {
		-- x =	-150127.671875,
		-- y = -110068.890625,
		-- elevation = 38,
		-- airdromeId = 6,
		-- ATC_frequency = "251.100",
		-- side = "blue",							-- side : info obligatoire
		-- divert = true,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "78X",							-- TACAN : optionnel
		-- ILS =  "RWY 27/110.75 RWY 09/110.70",	-- ILS : optionnel
	-- },
	-- ['AB test 02'] = {
		-- x =	-140127.671875,
		-- y = -120068.890625,
		-- elevation = 38,
		-- airdromeId = 6,
		-- ATC_frequency = "251.250",
		-- side = "blue",							-- side : info obligatoire
		-- divert = true,							-- divert : info obligatoire (pour l instant)
		-- -- TACAN = "78X",							-- TACAN : optionnel
		-- -- ILS =  "RWY 27/110.75 RWY 09/110.70",	-- ILS : optionnel
	-- },
	-- ['AB test 03'] = {
		-- x =	-145127.671875,
		-- y = -115068.890625,
		-- elevation = 38,
		-- airdromeId = 6,
		-- ATC_frequency = "251.500",
		-- side = "blue",							-- side : info obligatoire
		-- divert = true,							-- divert : info obligatoire (pour l instant)
		-- TACAN = "47X",							-- TACAN : optionnel
		-- ILS =  "RWY 08/108.90",					-- ILS : optionnel
	-- },
	-- ['AB test 04'] = {
		-- x =	-130127.671875,
		-- y = -100068.890625,
		-- elevation = 38,
		-- airdromeId = 6,
		-- ATC_frequency = "251.750",
		-- side = "red",							-- side : info obligatoire
		-- divert = true,							-- divert : info obligatoire (pour l instant)
		-- -- TACAN = "78X",							-- TACAN : optionnel
		-- ILS =  "RWY 09/111.50",					-- ILS : optionnel
	-- },
}
	